// priority: 150
onEvent("recipes", (event) => {
  //More unification stuff can be done through tags.js instead, or stonecutter.js!

  //Replaces all material of a type in the game with another (in recipes)
  let replaceIO = (i, o) => {
    event.replaceInput(i, o);
    event.replaceOutput(i, o);
  };

  const IESlab = (metal, metalBlockToUse) => {
    event.shaped('6x immersiveengineering:slab_storage_' + metal, ['BBB', '   ', '   '], {
      B: '#forge:storage_blocks/' + metal
    }).id('immersiveengineering:crafting/storage_' + metal + '_to_slab');

    event.shaped(metalBlockToUse, ['S ', 'S '], {
      S: 'immersiveengineering:slab_storage_' + metal
    }).id('immersiveengineering:crafting/storage_' + metal + '_from_slab');
  }

  IESlab('lead', 'thermal:lead_block')
  IESlab('silver', 'thermal:silver_block')
  IESlab('nickel', 'thermal:nickel_block')
  IESlab('uranium', 'mekanism:block_uranium')
  IESlab('electrum', 'thermal:electrum_block')
  IESlab('constantan', 'thermal:constantan_block')
  IESlab('steel', 'mekanism:block_steel')

  /*
  //Need to remove the recipes of those items and unhide them later
  replaceIO("immersiveengineering:plate_copper", "create:copper_sheet");
  replaceIO("immersiveengineering:plate_gold", "create:golden_sheet");
  replaceIO("immersiveengineering:plate_iron", "create:iron_sheet");
  replaceIO("createdeco:zinc_sheet", "createaddition:zinc_sheet");
  replaceIO("immersiveengineering:stick_iron", "createaddition:iron_rod"); */

  //For some recipe for bullets in Immersive Engineering table
  event.replaceOutput('immersiveengineering:nugget_steel', 'mekanism:nugget_steel');
  event.replaceOutput('mekanism:dust_sulfur', 'thermal:sulfur_dust');
  event.replaceOutput('immersiveengineering:dust_saltpeter', 'thermal:niter_dust');

  //Remove old material recipes
  //IE Lead
  event.remove({ id: 'immersiveengineering:crafting/storage_lead_to_ingot_lead' });
  event.remove({ id: 'immersiveengineering:crafting/nugget_lead_to_ingot_lead' });
  event.remove({ id: 'create:blasting/ingot_lead_compat_immersiveengineering' });
  event.remove({ id: 'immersiveengineering:smelting/ingot_lead_from_blasting3' });
  event.remove({ id: 'immersiveengineering:smelting/ingot_lead_from_blasting2' });
  event.remove({ id: 'immersiveengineering:smelting/ingot_lead_from_blasting' });
  event.remove({ id: 'immersiveengineering:smelting/ingot_lead_from_dust_from_blasting' });
  event.remove({ id: 'immersiveengineering:smelting/ingot_lead3' });
  event.remove({ id: 'immersiveengineering:smelting/ingot_lead2' });
  event.remove({ id: 'immersiveengineering:smelting/ingot_lead' });
  event.remove({ id: 'immersiveengineering:smelting/ingot_lead_from_dust' });
  event.remove({ id: 'immersiveengineering:crafting/raw_block_lead_to_raw_lead' });
  event.remove({ id: 'immersiveengineering:crafting/raw_lead_to_raw_block_lead' });
  event.remove({ id: 'immersiveengineering:crafting/ingot_lead_to_nugget_lead' });
  event.remove({ id: 'create:splashing/immersiveengineering/crushed_lead_ore' });
  event.remove({ id: 'create:smelting/ingot_lead_compat_immersiveengineering' });
  event.remove({ id: 'immersiveengineering:crafting/ingot_lead_to_storage_lead' });

  //IE Uranium
  event.remove({ id: 'immersiveengineering:crafting/storage_uranium_to_ingot_uranium' });
  event.remove({ id: 'immersiveengineering:crafting/nugget_uranium_to_ingot_uranium' });
  event.remove({ id: 'create:blasting/ingot_uranium_compat_immersiveengineering' });
  event.remove({ id: 'immersiveengineering:smelting/ingot_uranium_from_blasting3' });
  event.remove({ id: 'immersiveengineering:smelting/ingot_uranium_from_blasting2' });
  event.remove({ id: 'immersiveengineering:smelting/ingot_uranium_from_blasting' });
  event.remove({ id: 'immersiveengineering:smelting/ingot_uranium_from_dust_from_blasting' });
  event.remove({ id: 'immersiveengineering:smelting/ingot_uranium3' });
  event.remove({ id: 'immersiveengineering:smelting/ingot_uranium2' });
  event.remove({ id: 'immersiveengineering:smelting/ingot_uranium' });
  event.remove({ id: 'immersiveengineering:smelting/ingot_uranium_from_dust' });
  event.remove({ id: 'immersiveengineering:crafting/raw_block_uranium_to_raw_uranium' });
  event.remove({ id: 'immersiveengineering:crafting/raw_uranium_to_raw_block_uranium' });
  event.remove({ id: 'immersiveengineering:crafting/ingot_uranium_to_nugget_uranium' });
  event.remove({ id: 'create:splashing/immersiveengineering/crushed_uranium_ore' });
  event.remove({ id: 'create:smelting/ingot_uranium_compat_immersiveengineering' });
  event.remove({ id: 'immersiveengineering:crafting/ingot_uranium_to_storage_uranium' });
  event.remove({ id: 'pneumaticcraft:block_heat_properties/immersiveengineering/uranium' });
  event.remove({ id: 'tconstruct:smeltery/casting/metal/uranium/block' });

  //IE Steel
  event.remove({ id: 'immersiveengineering:crafting/ingot_steel_to_storage_steel' });
  event.remove({ id: 'immersiveengineering:crafting/ingot_steel_to_nugget_steel' });
  event.remove({ id: 'immersiveengineering:crafting/storage_steel_to_ingot_steel' });
  event.remove({ id: 'immersiveengineering:crafting/nugget_steel_to_ingot_steel' });
  event.remove({ id: 'immersiveengineering:smelting/ingot_steel_from_dust' });
  event.remove({ id: 'immersiveengineering:smelting/ingot_steel_from_dust_from_blasting' });
  event.remove({ id: 'tconstruct:smeltery/casting/metal/steel/block' });

  //IE Nickel
  event.remove({ id: 'immersiveengineering:smelting/ingot_nickel' });
  event.remove({ id: 'immersiveengineering:smelting/ingot_nickel2' });
  event.remove({ id: 'immersiveengineering:crafting/storage_nickel_to_ingot_nickel' });
  event.remove({ id: 'immersiveengineering:crafting/nugget_nickel_to_ingot_nickel' });
  event.remove({ id: 'immersiveengineering:smelting/ingot_nickel_from_dust' });
  event.remove({ id: 'immersiveengineering:smelting/ingot_nickel3' });
  event.remove({ id: 'create:smelting/ingot_nickel_compat_immersiveengineering' });
  event.remove({ id: 'immersiveengineering:crafting/ingot_nickel_to_storage_nickel' });
  event.remove({ id: 'immersiveengineering:crafting/ingot_nickel_to_nugget_nickel' });
  event.remove({ id: 'immersiveengineering:smelting/ingot_nickel_from_dust_from_blasting' });
  event.remove({ id: 'immersiveengineering:smelting/ingot_nickel_from_blasting3' });
  event.remove({ id: 'immersiveengineering:smelting/ingot_nickel_from_blasting2' });
  event.remove({ id: 'immersiveengineering:smelting/ingot_nickel_from_blasting' });
  event.remove({ id: 'create:blasting/ingot_nickel_compat_immersiveengineering' });
  event.remove({ id: 'create:splashing/immersiveengineering/crushed_nickel_ore' });
  event.remove({ id: 'immersiveengineering:crafting/raw_block_nickel_to_raw_nickel' });
  event.remove({ id: 'immersiveengineering:crafting/raw_nickel_to_raw_block_nickel' });
  event.remove({ id: 'tconstruct:smeltery/casting/metal/nickel/block' });

  //Mekanism Tin
  event.remove({ id: 'mekanism:processing/tin/ore/from_raw' });
  event.remove({ id: 'mekanism:processing/tin/ore/deepslate_from_raw' });
  event.remove({ id: 'mekanism:processing/tin/ingot/from_block' });
  event.remove({ id: 'mekanism:processing/tin/ingot/from_nuggets' });
  event.remove({ id: 'mekanism:processing/tin/ingot/from_raw_blasting' });
  event.remove({ id: 'create:blasting/ingot_tin_compat_mekanism' });
  event.remove({ id: 'mekanism:processing/tin/ingot/from_ore_blasting' });
  event.remove({ id: 'mekanism:processing/tin/ingot/from_dust_blasting' });
  event.remove({ id: 'create:smelting/ingot_tin_compat_mekanism' });
  event.remove({ id: 'mekanism:processing/tin/ingot/from_dust_smelting' });
  event.remove({ id: 'mekanism:processing/tin/ingot/from_ore_smelting' });
  event.remove({ id: 'mekanism:processing/tin/ingot/from_raw_smelting' });
  event.remove({ id: 'mekanism:processing/tin/nugget/from_ingot' });
  event.remove({ id: 'create:splashing/mekanism/crushed_tin_ore' });
  event.remove({ id: 'mekanism:processing/tin/raw/from_raw_block' });
  event.remove({ id: 'mekanism:processing/tin/raw_storage_blocks/from_raw' });
  event.replaceOutput({ type: 'mekanism:enriching' }, 'mekanism:dust_tin', 'thermal:tin_dust')
  event.replaceOutput({ type: 'mekanism:crushing' }, 'mekanism:dust_tin', 'thermal:tin_dust')
  event.remove({ id: 'mekanism:processing/tin/storage_blocks/from_ingots' });
  event.remove({ id: 'tconstruct:smeltery/casting/metal/tin/block' });

  //Mekanism Lead
  event.remove({ id: 'mekanism:processing/lead/raw/from_raw_block' });
  event.remove({ id: 'mekanism:processing/lead/nugget/from_ingot' });
  event.remove({ id: 'create:splashing/mekanism/crushed_lead_ore' });
  event.remove({ id: 'mekanism:processing/lead/ingot/from_block' });
  event.remove({ id: 'mekanism:processing/lead/ingot/from_nuggets' });
  event.remove({ id: 'mekanism:processing/lead/ingot/from_raw_blasting' });
  event.remove({ id: 'mekanism:processing/lead/ingot/from_ore_blasting' });
  event.remove({ id: 'create:blasting/ingot_lead_compat_mekanism' });
  event.remove({ id: 'mekanism:processing/lead/ingot/from_dust_blasting' });
  event.remove({ id: 'mekanism:processing/lead/ingot/from_raw_smelting' });
  event.remove({ id: 'mekanism:processing/lead/ingot/from_dust_smelting' });
  event.remove({ id: 'create:smelting/ingot_lead_compat_mekanism' });
  event.remove({ id: 'mekanism:processing/lead/ingot/from_ore_smelting' });
  event.replaceOutput({ type: 'mekanism:enriching' }, 'mekanism:dust_lead', 'thermal:lead_dust')
  event.replaceOutput({ type: 'mekanism:crushing' }, 'mekanism:dust_lead', 'thermal:lead_dust')
  event.remove({ id: 'mekanism:processing/lead/storage_blocks/from_ingots' });
  event.remove({ id: 'tconstruct:smeltery/casting/metal/lead/block' });

  //IE Silver
  event.remove({ id: 'immersiveengineering:crafting/nugget_silver_to_ingot_silver' });
  event.remove({ id: 'immersiveengineering:smelting/ingot_silver_from_blasting' });
  event.remove({ id: 'immersiveengineering:smelting/ingot_silver' });
  event.remove({ id: 'immersiveengineering:smelting/ingot_silver_from_blasting2' });
  event.remove({ id: 'immersiveengineering:smelting/ingot_silver2' });
  event.remove({ id: 'immersiveengineering:crafting/ingot_silver_to_storage_silver' });
  event.remove({ id: 'immersiveengineering:crafting/ingot_silver_to_nugget_silver' });
  event.remove({ id: 'immersiveengineering:crafting/storage_silver_to_ingot_silver' });
  event.remove({ id: 'create:blasting/ingot_silver_compat_immersiveengineering' });
  event.remove({ id: 'immersiveengineering:smelting/ingot_silver_from_blasting' });
  event.remove({ id: 'immersiveengineering:smelting/ingot_silver_from_dust_from_blasting' });
  event.remove({ id: 'immersiveengineering:smelting/ingot_silver_from_blasting3' });
  event.remove({ id: 'immersiveengineering:smelting/ingot_silver_from_blasting2' });
  event.remove({ id: 'create:smelting/ingot_silver_compat_immersiveengineering' });
  event.remove({ id: 'immersiveengineering:smelting/ingot_silver_from_dust' });
  event.remove({ id: 'immersiveengineering:smelting/ingot_silver' });
  event.remove({ id: 'immersiveengineering:smelting/ingot_silver3' });
  event.remove({ id: 'immersiveengineering:smelting/ingot_silver2' });
  event.remove({ id: 'immersiveengineering:crafting/raw_block_silver_to_raw_silver' });
  event.remove({ id: 'immersiveengineering:crafting/raw_silver_to_raw_block_silver' });
  event.remove({ id: 'immersiveengineering:smelting/ingot_silver_from_dust_from_blasting' });
  event.remove({ id: 'create:splashing/immersiveengineering/crushed_silver_ore' });
  event.remove({ id: 'tconstruct:smeltery/casting/metal/silver/block' });

  //Occultism Silver
  event.replaceOutput('occultism:silver_dust', 'thermal:silver_dust');
  event.remove({ id: 'occultism:crafting/silver_block' });
  event.remove({ id: 'occultism:crafting/silver_nugget' });
  event.remove({ id: 'occultism:crafting/silver_ingot_from_nuggets' });
  event.remove({ id: 'occultism:crafting/silver_ingot_from_block' });
  event.remove({ id: 'occultism:smelting/silver_ingot_from_raw' });
  event.remove({ id: 'occultism:smelting/silver_ingot_from_dust' });
  event.remove({ id: 'occultism:smelting/silver_ingot' });
  event.remove({ id: 'occultism:blasting/silver_ingot_from_raw' });
  event.remove({ id: 'occultism:blasting/silver_ingot_from_dust' });
  event.remove({ id: 'occultism:blasting/silver_ingot' });

  //Niter stuff
  event.remove({ id: 'immersiveengineering:crafting/gunpowder_from_dusts' });

  //Copper dusts
  event.replaceOutput('mekanism:dust_copper', 'thermal:copper_dust');
  event.replaceOutput('occultism:copper_dust', 'thermal:copper_dust');
  event.remove({ id: 'immersiveengineering:smelting/copper_ingot_from_dust' });
  event.remove({ id: 'immersiveengineering:smelting/copper_ingot_from_dust_from_blasting' });

  //Gold dusts
  event.replaceOutput('mekanism:dust_gold', 'thermal:gold_dust');
  event.replaceOutput('occultism:gold_dust', 'thermal:gold_dust');
  event.remove({ id: 'immersiveengineering:smelting/gold_ingot_from_dust' });
  event.remove({ id: 'immersiveengineering:smelting/gold_ingot_from_dust_from_blasting' });

  //Iron dusts
  event.replaceOutput('mekanism:dust_iron', 'thermal:iron_dust');
  event.replaceOutput('occultism:iron_dust', 'thermal:iron_dust');
  event.remove({ id: 'immersiveengineering:smelting/iron_ingot_from_dust' });
  event.remove({ id: 'immersiveengineering:smelting/iron_ingot_from_dust_from_blasting' });

  //Bronze
  event.remove({ id: 'mekanism:nuggets/bronze' });
  event.remove({ id: 'mekanism:processing/bronze/ingot/from_nuggets' });
  event.remove({ id: 'mekanism:processing/bronze/ingot/from_block' });
  event.remove({ id: 'mekanism:processing/bronze/ingot/from_dust_smelting' });
  event.remove({ id: 'mekanism:processing/bronze/ingot/from_dust_blasting' });
  event.remove({ id: 'mekanism:storage_blocks/bronze' });
  event.remove({ id: 'tconstruct:smeltery/casting/metal/bronze/block' });
  event.replaceOutput('mekanism:dust_bronze', 'thermal:bronze_dust');
  event.replaceOutput('mekanism:nugget_bronze', 'thermal:bronze_nugget');
  event.replaceOutput('mekanism:ingot_bronze', 'thermal:bronze_ingot');

  //Netherite dust
  event.remove({ id: 'mekanism:processing/netherite/ingot_from_dust_smelting' });
  event.remove({ id: 'mekanism:processing/netherite/ingot_from_dust_blasting' });
  replaceIO('mekanism:dust_netherite', 'thermal:netherite_dust');

  //Potato Crates
  event.remove({ id: 'quark:building/crafting/compressed/potato_crate' });
  event.remove({ id: 'farmersdelight:potato_crate' });

  //Constantan
  event.remove({ id: 'immersiveengineering:crafting/storage_constantan_to_ingot_constantan' });
  event.remove({ id: 'immersiveengineering:crafting/nugget_constantan_to_ingot_constantan' });
  event.remove({ id: 'immersiveengineering:smelting/ingot_constantan_from_dust' });
  event.remove({ id: 'immersiveengineering:smelting/ingot_constantan_from_dust_from_blasting' });
  event.remove({ id: 'immersiveengineering:crafting/constantan_mix' });
  event.remove({ id: 'immersiveengineering:crafting/ingot_constantan_to_nugget_constantan' });
  event.remove({ id: 'immersiveengineering:smelting/ingot_constantan_from_dust' });
  event.remove({ id: 'immersiveengineering:smelting/ingot_constantan_from_dust_from_blasting' });
  event.remove({ id: 'immersiveengineering:crafting/ingot_constantan_to_storage_constantan' });
  event.remove({ id: 'tconstruct:smeltery/casting/metal/constantan/block' });
  event.replaceOutput('immersiveengineering:dust_constantan', 'thermal:constantan_dust');
  event.replaceOutput('immersiveengineering:ingot_constantan', 'thermal:constantan_ingot');

  //Bamboo bundle
  event.remove({ id: 'quark:building/crafting/compressed/bamboo_block' });
  event.remove({ id: 'thermal:storage/bamboo_block' });

  //Red brick slabs vertical
  event.remove({ id: 'createdeco:red_bricks_slab_vert' });
  event.remove({ id: 'createdeco:mossy_red_bricks_slab_vert' });
  event.remove({ id: 'createdeco:cracked_red_bricks_slab_vert' });
  event.remove({ id: 'createdeco:cracked_red_bricks_slab_vert_from_brick_slab_blasting' });

  //Carrot Crates
  event.remove({ id: 'quark:building/crafting/compressed/carrot_crate' });
  event.remove({ id: 'farmersdelight:carrot_crate' });

  //Gunpowder Sack
  event.remove({ id: 'quark:building/crafting/compressed/gunpowder_sack' });

  //Sugar Cane Block
  event.remove({ id: 'quark:sugar_cane_block' });

  //Copper nuggets
  event.remove({ id: 'create:crafting/materials/copper_nugget' });
  event.remove({ id: 'immersiveengineering:crafting/copper_ingot_to_nugget_copper' });
  event.remove({ id: 'malum:copper_nugget_from_ingot' });
  event.remove({ id: 'tconstruct:common/materials/copper_nugget_from_ingot' });
  event.remove({ id: 'tconstruct:common/materials/copper_ingot_from_nuggets' });
  event.remove({ id: 'immersiveengineering:crafting/nugget_copper_to_copper_ingot' });
  event.replaceOutput('create:copper_nugget', 'thermal:copper_nugget')
  event.replaceOutput('malum:copper_nugget', 'thermal:copper_nugget')

  //Daylight sensor
  event.remove({ id: 'ae2:misc/vanilla_daylight_detector' });

  //Slimeball stuff since TConstruct takes care of adding new recipes
  event.remove({ id: 'minecraft:magma_cream' })
  event.remove({ id: 'minecraft:lead' })

  //Apple Crate
  event.remove({ id: 'quark:building/crafting/compressed/apple_crate' });

  //Electrum
  event.remove({ id: 'immersiveengineering:crafting/ingot_electrum_to_nugget_electrum' });
  event.remove({ id: 'immersiveengineering:crafting/nugget_electrum_to_ingot_electrum' });
  event.remove({ id: 'immersiveengineering:crafting/storage_electrum_to_ingot_electrum' });
  event.remove({ id: 'immersiveengineering:smelting/ingot_electrum_from_dust' });
  event.remove({ id: 'immersiveengineering:smelting/ingot_electrum_from_dust_from_blasting' });
  event.remove({ id: 'immersiveengineering:crafting/ingot_electrum_to_storage_electrum' });
  event.remove({ id: 'tconstruct:smeltery/casting/metal/electrum/block' });
  event.replaceOutput('immersiveengineering:dust_electrum', 'thermal:electrum_dust')
  event.replaceOutput('immersiveengineering:ingot_electrum', 'thermal:electrum_ingot')

  //Beetroot Crate
  event.remove({ id: 'farmersdelight:beetroot_crate' });
  event.remove({ id: 'quark:building/crafting/compressed/beetroot_crate' });

  //IE Coal Coke
  event.remove({ id: 'immersiveengineering:crafting/coke_to_slab' });
  event.shaped('6x immersiveengineering:slab_coke', ['BBB', '   ', '   '], {
    B: '#forge:storage_blocks/coal_coke'
  })
  event.remove({ id: 'immersiveengineering:crafting/coke_from_slab' });
  event.shaped('thermal:coal_coke_block', ['S ', 'S '], {
    S: 'immersiveengineering:slab_coke'
  })
  event.remove({ id: 'immersiveengineering:crafting/coal_coke_to_coke' })
  event.remove({ id: 'immersiveengineering:crafting/coke_to_coal_coke' })
  event.shapeless('9x thermal:coal_coke', 'immersiveengineering:coke');

  //Emerald Dust
  replaceIO('mekanism:dust_emerald', 'thermal:emerald_dust');

  //Diamond Dust
  event.replaceOutput('mekanism:dust_diamond', 'thermal:diamond_dust');
  event.replaceOutput('createaddition:diamond_grit', 'thermal:diamond_dust')
  event.replaceOutput('hearthstones:diamond_dust', 'thermal:diamond_dust')

  //Ender Dust
  event.replaceOutput('ae2:ender_dust', 'thermal:ender_pearl_dust')

  //Lapis Dust
  event.replaceOutput('hearthstones:lapis_dust', 'thermal:lapis_dust')
  event.replaceOutput('mekanism:dust_lapis_lazuli', 'thermal:lapis_dust')

  //Obsidian Dusts
  event.replaceOutput('create:powdered_obsidian', 'mekanism:dust_obsidian')
  event.replaceOutput('occultism:obsidian_dust', 'mekanism:dust_obsidian')

  //Sawdust
  event.replaceOutput('mekanism:sawdust', 'thermal:sawdust')

  //Flour
  replaceIO('create:wheat_flour', 'pneumaticcraft:wheat_flour')

  //Tomato Crate
  event.shapeless('thermal:tomato_block', '9x thermal:tomato').id('thermal:storage/tomato_block');

  //Rice Crate
  event.shapeless('thermal:rice_block', '9x thermal:rice').id('thermal:storage/rice_block');

  //Onion Crate
  event.shapeless('thermal:onion_block', '9x thermal:onion').id('thermal:storage/onion_block');

  /*  event.remove({ id: 'aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa' });
      event.remove({ id: 'aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa' });
      event.remove({ id: 'aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa' });
      event.remove({ id: 'aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa' }); */

  event.replaceOutput('createdeco:iron_coin', 'thermal:iron_coin')
  event.replaceOutput('createdeco:copper_coin', 'thermal:copper_coin')
  event.replaceOutput('createdeco:gold_coin', 'thermal:coin_coin')
  event.replaceOutput('createdeco:netherite_coin', 'thermal:netherite_coin')
  event.replaceInput('createdeco:iron_coin', 'thermal:iron_coin')
  event.replaceInput('createdeco:copper_coin', 'thermal:copper_coin')
  event.replaceInput('createdeco:gold_coin', 'thermal:coin_coin')
  event.replaceInput('createdeco:netherite_coin', 'thermal:netherite_coin')

  let thermalPress = (inputTag, pressDie, outputItem, outputCount) => {
    event.custom({
      "type": "thermal:press",
      "ingredients": [
        {
          "tag": inputTag
        },
        {
          "item": pressDie
        }
      ],
      "result": [
        {
          "item": outputItem,
          "count": outputCount
        }
      ],
      "energy": 2400
    })
  }

  thermalPress('forge:ingots/zinc', 'thermal:press_coin_die', 'createdeco:zinc_coin', 3)
  thermalPress('forge:ingots/brass', 'thermal:press_coin_die', 'createdeco:brass_coin', 3)
  thermalPress('forge:ingots/cast_iron', 'thermal:press_coin_die', 'createdeco:cast_iron_coin', 3)
});
